$(document).ready(function(){

	var loader = new Image();
	loader.src = 'images/loader.gif';

	// Binding an listener to the submit event on the form:
	$('form').submit(function(e){
		e.preventDefault();
		// If a previous submit is in progress:
		if($('form').hasClass('active')) return false;
		
		// Adding the active class to the button. Will show the preloader gif:
		$('form').addClass('active');
		
		// Removing the current error tooltips
		$('.toolTip').html(loader);

		// Issuing a POST ajax request to submit.php (the action attribute of the form):
		$.post($('form').attr('action'),$('form').serialize()+'&fromAjax=1',function(response){
			
			if(!response.status)
			{
				// Some kind of input error occured
				$('input').removeClass('missing');

				// Looping through all the input text boxes,
				// and checking whether they produced an error
				$('input[type!=submit]').each(function(){
					var elem = $(this);
					var id = elem.attr('id');
					
					if(response[id]){
						errorMessage(response[id]);
						
						setTimeout(function(){
							//elem.addClass('missing');
							//$('.toolTip').html('text...');
						}, 1000);
					}
				});
			} else {
					setTimeout(function(){
						showTooltip(response['thanks']);
						//window.location = 'http://domain.co.uk/thank-you.html';
					}, 2000);
			}
			$('form').removeClass('active');
		},'json');

	});


});

var phrase = '';
var i = 0;

function errorMessage(txt){

	$('.toolTip').html(txt);
	setTimeout(function(){
		$('.toolTip').fadeOut('fast',function(){
			$('.toolTip').html('text...');
			$('.toolTip').fadeIn('slow');
		});
	},4000);
}

// Helper function that creates an error tooltip:

function showTooltip(txt){

	setTimeout(function(){

		if (i == txt.length){

			setTimeout(function(){
				$('form input[name!=Send], textarea').val('');
				$('.toolTip').fadeOut('fast',function(){
					$('.toolTip').html('text...');
					$('.toolTip').fadeIn('slow');
					//$('label').css({opacity:0,display:'block'}).animate({opacity:1},'slow').focus().blur();
				});
				phrase = '';
				i = 0;
				return
			},4000);

		} else {

			phrase += txt.charAt(i);

			$('.toolTip').html('<span>'+phrase+'</span>');

			i++;

			showTooltip(txt);

		}


	},50);

}