<?php

class WPC_Tools_Public_Module_Default_Pages extends WPC_Tools_Public_Module {

  const MODULE_NAME = WPC_Tools_Admin_Module_Default_Pages::MODULE_NAME;

  protected static $_instance = null;

  /**
   * WPC Tools Admin Instance.
   *
   * Ensures only one instance of WPC_Tools_Admin is loaded or can be loaded.
   */
  public static function instance() {
    if ( is_null( self::$_instance ) ) {
      self::$_instance = new self();
    }

    return self::$_instance;
  }

  /**
   * WPC_Tools_Module_Default_Pages constructor.
   */
  public function __construct() {
    $this->settings_title = str_replace( '-', '_', self::MODULE_NAME );
    $this->module_hooks();
  }

  /**
   * Load General Module hooks
   */
  private function module_hooks() {
    WPC_Tools::loader()->add_action( 'pre_get_posts', $this, 'set_post_type_count', 90 );
  }

  /**
   * Change posts_per_page based on default settings
   *
   * @param $query
   */
  public function set_post_type_count( $query ) {

    if ( $query->is_main_query() && ( ! is_admin() || ( is_admin() && ( defined( 'DOING_AJAX' ) && DOING_AJAX ) ) ) ) {

      $post_type = $query->get( 'post_type' );

      if ( is_tax() ) {
        $taxonomy     = $query->tax_query->queries[ 0 ][ 'taxonomy' ];
        $taxonomy_obj = get_taxonomy( $taxonomy );
        $post_type    = $taxonomy_obj->object_type[ 0 ];
      }

      if ( is_array( $post_type ) ) {
        return;
      }

      $ppp = get_option( $post_type . '_per_page', false );

      if ( $ppp ) {
        $query->set( 'posts_per_page', intval( $ppp ) );
      }

    }

    return;
  }
}
