(function ($) {
  'use strict';

  var acfCurrencySettings = {
    init: function () {
      this.initSortableCurrencies();
      this.initAddCurrency();
      this.initRemoveCurrency($('.currency-container'));
    },
    initSortableCurrencies: function () {
      $('.currency-wrap').sortable({
        stop: function () {
          $('.currency-container').each(function (index) {
            $(this).find('input').each(function () {
              this.name = this.name.replace(/\[(\d+)\]/, function () {
                return '[' + index + ']';
              });
            });
          });
        },
      });
    },
    initAddCurrency: function () {
      var that = this;
      var $currenciesWrap = $('.currency-wrap');

      $('.add-currency-button-wrap button').on('click', function (e) {
        e.preventDefault();

        if ($currenciesWrap.hasClass('hidden')) {
          $currenciesWrap.removeClass('hidden')
        } else {
          var $currency = $('.currency-container:last', $currenciesWrap).clone();

          $currency.find('input').each(function () {
            this.value = '';
            this.name = this.name.replace(/\[(\d+)\]/, function (str, p1) {
              return '[' + (parseInt(p1, 10) + 1) + ']';
            });
          }).end().appendTo($currenciesWrap);

          that.initRemoveCurrency($currency);
        }
      });
    },
    initRemoveCurrency: function ($currency) {
      var $currenciesWrap = $('.currency-wrap');

      $currency.find('.remove-currency').on('click', function (e) {
        e.preventDefault();

        var $currencies = $('.currency-container', $currenciesWrap);

        if ($currencies.length > 1) {
          $(this).parent().remove();
        } else {
          $(this).parent().find('input').val('');
          $currenciesWrap.addClass('hidden');
        }
      });
    },
  };

  $(function () {
    acfCurrencySettings.init();
  });

})(jQuery);
