@if( have_rows('cta_block') )
  @while( have_rows('cta_block') ) @php( the_row() )

  @php
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'cta_block' . '-' ),
      'title' => get_sub_field( 'title' ),
      'sub_title' => get_sub_field( 'sub_title' ),
      'text' => get_sub_field( 'text' ),
      'buttons' => get_sub_field( 'buttons' ),
      'image' => get_sub_field( 'image' ),
      'direction' => get_sub_field( 'direction' ),
      'padding' => get_sub_field( 'cta_block_padding' ),
    ];

    $classes = [
      'layout-item',
      'cta_block',
      'direction-' . $fields['direction'],
      'pt-' . $fields['padding']['top'],
      'pb-' . $fields['padding']['bottom']
    ];

    $image_max_height = empty( $fields['image']['sizes']['hux-thumbnail-sm-height'] ) ? false : $fields['image']['sizes']['hux-thumbnail-sm-height'];
    $image_ratio = ( $fields['image']['height'] / $fields['image']['width'] ) * 100;

  $thumbnailAnim = array(
    'animation' => 'fade',
    'delay'     => 0.2,
    'duration'  => 1,
    'easing'    => '',
    'anchor'    => ''
  );

  $contentAnim = array(
    'animation' => 'fade-up',
    'delay'     => 0.2,
    'duration'  => 1,
    'easing'    => '',
    'anchor'    => ''
  );
  @endphp

  @if( ! empty( $fields['title'] ) || ! empty( $fields['sub_title'] ) || ! empty( $fields['text'] ) || ! empty( $fields['buttons'] || ! empty( $fields['image'] ) ) )
    <section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}">
      <div class="container">
        <div class="row align-items-md-center {{ ( $fields['direction'] === 'left' ) ? '' : 'flex-md-row-reverse' }}">
          <div class="col-md-8">
            @if( ! empty( $fields['image'] ) )
              <figure class="ctab-thumbnail img-cover mb-0" data-min="768" style="padding-top: {{ absint( $image_ratio ) }}%; {{ empty( $image_max_height ) ? '' : 'min-height: ' . $image_max_height  . 'px' }}" <?= \App\get_the_aos($thumbnailAnim); ?>>
                {!! \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-md' ) !!}
              </figure>
            @endif
          </div>

          <div class="col-md-4">
            <div class="ctab-content">
              @if( ! empty( $fields['sub_title'] ) )
                <h4 class="ctab-sub-title" <?= \App\get_the_aos($contentAnim); ?>>
                  {{ $fields['sub_title'] }}
                </h4>
              @endif

              @if( ! empty( $fields['title'] ) )
                <h3 class="ctab-title" <?= \App\get_the_aos($contentAnim); ?>>
                  {{ $fields['title'] }}
                </h3>
              @endif

              @if( ! empty( $fields['text'] ) )
                <div class="ctab-text rlpm" <?= \App\get_the_aos($contentAnim); ?>>
                  {!! $fields['text'] !!}
                </div>
              @endif

              @if( ! empty( $fields['buttons'] ) )
                <div class="ctab-buttons btn-troop" <?= \App\get_the_aos($contentAnim); ?>>
                  @foreach( $fields['buttons'] as $button )
                    {!! \App\the_wpc_button([
                      'data' => $button['button']
                    ]) !!}
                  @endforeach
                </div>
              @endif
            </div>
          </div>
        </div>
      </div>
    </section>
  @endif

  @endwhile
@endif
