@if( have_rows('post_type_carousel') )
  @while( have_rows('post_type_carousel') ) @php( the_row() )

  @php
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'post_type_carousel' . '-' ),
      'post_type' => get_sub_field( 'post_type' ),
      'posts_to_show' => get_sub_field( 'posts_to_show' ),
      'posts_per_page' => get_sub_field( 'posts_per_page' ),
      'orderby' => get_sub_field( 'orderby' ),
      'order' => get_sub_field( 'order' ),
      'buttons' => get_sub_field( 'buttons' ),
      'background' => get_sub_field( 'background' ),
      'padding' => get_sub_field( 'post_type_carousel_padding' ),
      'slider_settings' => get_sub_field( 'post_type_carousel_slider_settings' ),
    ];

    $classes = [
      'layout-item',
      'post_type_carousel',
      $fields['background'],
      'pt-' . $fields['padding']['top'],
      'pb-' . $fields['padding']['bottom']
    ];

    $fields['slides'] = get_posts([
      'post_type' => $fields['post_type'],
      'post_status' => 'publish',
      'orderby' => $fields['orderby'],
      'order' => $fields['order'],
      'posts_per_page' => absint( $fields['posts_to_show'] )
    ]);

    if( \App\layout_has_bg( $fields['background'] ) ) {
      $classes[] = 'has-bg';
    }
  @endphp

  @if( ! empty( $fields['slides'] ) )
    <section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}">
      <div class="container">
        <div class="post-type-carousel-wrap eh-container {{ $fields['slider_settings']['dots'] === 'enabled' ? 'has-dots' : '' }} {{ $fields['slider_settings']['arrows'] === 'enabled' ? 'has-arrows' : '' }}">
          <div class="post-type-carousel row"
               data-arrows="{{ $fields['slider_settings']['arrows'] }}"
               data-dots="{{ $fields['slider_settings']['dots'] }}"
               data-autoplay="{{ $fields['slider_settings']['autoplay'] }}"
               data-interval="{{ $fields['slider_settings']['interval'] * 1000 }}">

            @foreach( $fields['slides'] as $slide )
              @if( ! empty( $thumbnail = get_field( 'thumbnail', $slide->ID ) ) )
              <div class="ptc-slide col">
                <div class="ptc-slide-inner">
                  <div class="ptc-slide-content eh-child">
                    @if( ! empty( $extra_field = apply_filters( 'hux/layouts/post_type_carousel/post_extra_fields', get_the_date( '', $post ), $post ) ) )
                      <p class="ptc-post-extra-field">{{ $extra_field }}</p>
                    @endif

                    <h4 class="ptc-slide-title">
                      {{ \App\title( $slide->ID ) }}
                    </h4>

                    <div class="ptc-button">
                      <a class="btn btn-primary" href="{{ get_the_permalink( $slide->ID ) }}" title="{{ __( 'Read more', 'hux' ) }}">
                        {{ __( 'Read more', 'hux' ) }}
                      </a>
                    </div>
                  </div>

                  <a class="ptc-slide-thumbnail mt-0 bg-cover eh-child" href="{{ get_the_permalink( $slide->ID ) }}" title="{{ __( 'Read more', 'hux' ) }}" style="background-image: url({{ $thumbnail['sizes']['hux-thumbnail'] }})"></a>
                </div>
              </div>
              @endif
            @endforeach
          </div>

          <div class="ptc-arrows"></div>
        </div>

        @if( ! empty( $fields['buttons'] ) )
          <div class="ptc-buttons btn-troop">
            @foreach( $fields['buttons'] as $button )
              {!! \App\the_wpc_button([
                'data' => $button['button']
              ]) !!}
            @endforeach
          </div>
        @endif
      </div>
    </section>
  @endif

  @endwhile
@endif
