<header class="banner">
  <div class="top">
    <div class="container">
      <div class="top-inner d-flex">
        <a class="brand" href="{{ home_url('/') }}" title="{{ get_bloginfo('name', 'display') }}">
          <?= wpc_get_the_svg_logo( 'secondary' ); ?>
        </a>

        <div class="socials d-none d-sm-flex ml-lg-auto">
          @include('partials.social-media-links')
        </div>

        <ul class="top-buttons d-flex ml-auto ml-lg-0">
          <li class="ml-auto d-lg-none">
            <a href="#" class="mobile-nav-toggle" data-toggle="mobile-nav">
              {{ __( 'Menu', 'hux' ) }}
              <i></i>
            </a>
          </li>
        </ul>
      </div>
    </div>
  </div>

  <div class="middle">
    <div class="container">
      <div class="middle-inner">
        <a class="brand" href="{{ home_url('/') }}" title="{{ get_bloginfo('name', 'display') }}">
          <?= wpc_get_the_svg_logo(); ?>
        </a>
      </div>
    </div>
  </div>

  <div class="bottom d-none d-lg-block">
    <div class="container">
      <div class="bottom-inner d-flex">
        <a class="brand" href="{{ home_url('/') }}" title="{{ get_bloginfo('name', 'display') }}">
          <?= wpc_get_the_svg_logo( 'secondary' ); ?>
        </a>

        <nav class="nav-primary ml-auto">
          @php
            if ( has_nav_menu( 'primary_navigation' ) ) :
              wp_nav_menu( [
                'theme_location' => 'primary_navigation',
                'menu_class' => 'nav',
                'link_before' => '<span>',
                'link_after' => '</span>'
              ] );
            endif;
          @endphp
        </nav>
      </div>
    </div>
  </div>

  <div class="mobile-nav" id="mobile-nav">
    <div class="mobile-nav-content">
      <nav class="nav-mobile">
        @php
          if ( has_nav_menu( 'mobile_navigation' ) ) :
            wp_nav_menu( [
              'theme_location' => 'mobile_navigation',
              'menu_class' => 'nav flex-column',
              'link_before' => '<span>',
              'link_after' => '</span>'
            ] );
          endif;
        @endphp
      </nav>
    </div>
  </div>
</header>
