<?php namespace App\HUX\Ajax\LoadPosts;

/**
 * Load more
 */
add_action('wp_ajax_hux_load_properties', __NAMESPACE__ . '\\hux_load_properties');
add_action('wp_ajax_nopriv_hux_load_properties', __NAMESPACE__ . '\\hux_load_properties');
function hux_load_properties() {
    global $wp_query;

    if (!wp_verify_nonce($_REQUEST['nonce'], 'hux-nonce') ||
        !isset($_REQUEST['post_type']) ||
        !isset($_REQUEST['posts_per_page']) ||
        !isset($_REQUEST['offset'])
    ) {
        wp_send_json_error();
        exit;
    }

    $posts_per_page = absint($_REQUEST['posts_per_page']);
    $post_type = $_REQUEST['post_type'];
    $offset = absint($_REQUEST['offset']);

    $args = [
        'post_type' => $post_type,
        'offset' => $offset,
        'posts_per_page' => $posts_per_page,
    ];

    // Prepare the tax query
    if (!empty($_REQUEST['region'])) {
        $args['tax_query'][] = [
            'taxonomy' => 'region',
            'field' => 'slug',
            'terms' => [$_REQUEST['region']],
        ];
    }

    // Prepare the tax query
    if (!empty($_REQUEST['status'])) {
        $args['tax_query'][] = [
            'taxonomy' => 'status',
            'field' => 'slug',
            'terms' => [$_REQUEST['status']],
        ];
    }

//
//    $currency_from = empty($_REQUEST['currency']) ? '_hux-price-from_gbp' : '_hux-price-from_' . $_REQUEST['currency'];
//    $min_price = empty($_REQUEST['min_price']) ? 0 : floor(floatval($_REQUEST['min_price']));
//    $max_price = empty($_REQUEST['max_price']) ? 0 : ceil(floatval($_REQUEST['max_price']));
//
//    $args['meta_query'] = array(
//        'relation' => 'AND',
//        [
//            'key' => $currency_from,
//            'value' => $min_price,
//            'compare' => '>=',
//        ],
//        [
//            'key' => $currency_from,
//            'value' => $max_price,
//            'compare' => '<=',
//        ],
//    );
    $wp_query = new \WP_Query($args);

    ob_start();

    $contentAnim = array(
        'animation' => 'fade-up',
        'delay' => 0.2,
        'duration' => 1,
        'easing' => '',
        'anchor' => ''
    );
    $i = 0;
    if (have_posts()) {

        while (have_posts()) {
            the_post();

            echo \App\template('partials.content-hux_property');
        }

    } else {
        wp_send_json_error();
        exit;
    }

    $html = ob_get_clean();

    $total_count = 0;
    $count_posts = wp_count_posts($post_type);

    if (isset($count_posts->publish)) {
        $total_count = $count_posts->publish;
    }

    wp_send_json_success([
        'html' => preg_replace('/\v(?:[\v\h]+)/', '', $html),
        'count' => isset($wp_query->found_posts) ? $wp_query->found_posts : $total_count,
        'offset' => $offset,
        'args' => $args,
//        'query' => $GLOBALS['wp_query']->request,
    ]);

    exit;
}
