<?php namespace App\HUX\PostTypes\Property;

// Register Custom Post Type

add_action('init', function () {

    $labels = array(
        'name' => _x('Properties', 'Post Type General Name', 'hux'),
        'singular_name' => _x('Property', 'Post Type Singular Name', 'hux'),
        'menu_name' => __('Properties', 'hux'),
        'name_admin_bar' => __('Property', 'hux'),
        'archives' => __('Item Archives', 'hux'),
        'attributes' => __('Item Attributes', 'hux'),
        'parent_item_colon' => __('Parent Item:', 'hux'),
        'all_items' => __('All Items', 'hux'),
        'add_new_item' => __('Add New Item', 'hux'),
        'add_new' => __('Add New', 'hux'),
        'new_item' => __('New Item', 'hux'),
        'edit_item' => __('Edit Item', 'hux'),
        'update_item' => __('Update Item', 'hux'),
        'view_item' => __('View Item', 'hux'),
        'view_items' => __('View Items', 'hux'),
        'search_items' => __('Search Item', 'hux'),
        'not_found' => __('Not found', 'hux'),
        'not_found_in_trash' => __('Not found in Trash', 'hux'),
        'featured_image' => __('Featured Image', 'hux'),
        'set_featured_image' => __('Set featured image', 'hux'),
        'remove_featured_image' => __('Remove featured image', 'hux'),
        'use_featured_image' => __('Use as featured image', 'hux'),
        'insert_into_item' => __('Insert into item', 'hux'),
        'uploaded_to_this_item' => __('Uploaded to this item', 'hux'),
        'items_list' => __('Items list', 'hux'),
        'items_list_navigation' => __('Items list navigation', 'hux'),
        'filter_items_list' => __('Filter items list', 'hux'),
    );
    $default_page_id = wpc_get_default_page_id('hux_property');
    $rewrite = array(
        'slug' => empty($default_page_id) ? 'properties' : get_page_uri($default_page_id),
        'with_front' => false,
        'pages' => true,
        'feeds' => true,
    );
    $args = array(
        'label' => __('Property', 'hux'),
        'description' => __('Post Type Description', 'hux'),
        'labels' => $labels,
        'supports' => array(),
        'taxonomies' => array('region'),
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-building',
        'show_in_admin_bar' => true,
        'show_in_nav_menus' => true,
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'page',
        'rewrite' => $rewrite,
    );
    register_post_type('hux_property', $args);
    flush_rewrite_rules();
}, 0);

add_action('init', function () {
    $labels = array(
        'name' => _x('Status', 'Taxonomy General Name', 'hux'),
        'singular_name' => _x('Status', 'Taxonomy Singular Name', 'hux'),
        'menu_name' => __('Status', 'hux'),
        'all_items' => __('All Items', 'hux'),
        'parent_item' => __('Parent Item', 'hux'),
        'parent_item_colon' => __('Parent Item:', 'hux'),
        'new_item_name' => __('New Item Name', 'hux'),
        'add_new_item' => __('Add New Item', 'hux'),
        'edit_item' => __('Edit Item', 'hux'),
        'update_item' => __('Update Item', 'hux'),
        'view_item' => __('View Item', 'hux'),
        'separate_items_with_commas' => __('Separate items with commas', 'hux'),
        'add_or_remove_items' => __('Add or remove items', 'hux'),
        'choose_from_most_used' => __('Choose from the most used', 'hux'),
        'popular_items' => __('Popular Items', 'hux'),
        'search_items' => __('Search Items', 'hux'),
        'not_found' => __('Not Found', 'hux'),
        'no_terms' => __('No items', 'hux'),
        'items_list' => __('Items list', 'hux'),
        'items_list_navigation' => __('Items list navigation', 'hux'),
    );
    $args = array(
        'labels' => $labels,
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_admin_column' => true,
        'show_in_nav_menus' => true,
        'show_tagcloud' => true,
        'rewrite' => false,
    );
    register_taxonomy('status', array('hux_property'), $args);
}, 0);
