// Utils
import initScrollTo from '../util/scrollTo';
import {eHeight} from '../util/eHeight';
import manageEheight from '../util/eHeight';
import {imgCover} from '../util/imgCover';
import manageImgCover from '../util/imgCover';
import { safariFix } from '../util/safariFix';
import manageSafariFix from '../util/safariFix';

// Components
import initAOS from '../src/aos';
import initMobileNavigation from '../src/mobileNavigation';
import initPostTypeCarousel from '../src/postTypeCarousel';
import initQuotes from '../src/quotes';
import initStickyNavigation from '../src/stickyNavigation';
import initCalculator from '../src/calculator';
import initVideoPopUp from '../src/videoPopUp';
import currencySwitch from '../src/switchCurrency';
import splitSlider from '../src/splitSlider';
import whyUsCarousel from '../src/whyUsCarousel';
// import initRangeSlider from '../src/rangeSlider';

export default {
  init() {
    eHeight();
    imgCover();
    initAOS();
    initMobileNavigation();
    initPostTypeCarousel();
    initQuotes();
    initScrollTo();
    initStickyNavigation();
    initCalculator();
    initVideoPopUp();
    currencySwitch();
    splitSlider();
    whyUsCarousel();
    // initRangeSlider();
    safariFix();

    $('body').on('eheight-finished', () => {
      imgCover();
    });

    let windowWidth = $(window).width();

    $(window).on('resize', () => {
      if ($(window).width() != windowWidth) {
        windowWidth = $(window).width();
        manageEheight();
        manageImgCover();
        whyUsCarousel();
        manageSafariFix();
      }
    });
  },
};
