import 'imagesloaded';
import manageImgCover from '../util/imgCover';
import videoPopUp from '../src/videoPopUp';

class manageCases {

  constructor() {
    this.$grid = $('.posts-wrap');
    this.$moreButton = $('.btn-load-more');
    this.globals = window.huxGlobals;
    this.data = {
      action: 'hux_load_cases',
      offset: 0,
      nonce: this.globals.nonce,
      post_type: this.globals.post_type,
      posts_per_page: this.globals.posts_per_page,
    };

    this.manageLoadMore();
  }

  getPosts() {
    this.$grid.addClass('posts-loading');

    return $.ajax({
      method: 'POST',
      url: this.globals.ajax_url,
      dataType: 'json',
      data: this.data,
      success: () => {
        this.$grid.removeClass('posts-loading');
      },
    });
  }

  handleResponse(response) {

    if (response.success) {
      const $elems = $(response.data.html);

      $('.alert', this.$grid).remove();

      this.$moreButton.removeClass('loading').attr('disabled', false);

      if (this.data.offset > 0) {
        this.$grid.append($elems);
        $elems.imagesLoaded(() => {
          manageImgCover();
        });
        videoPopUp();
      }

      if (parseInt(response.data.count) === $('.hentry').length) {
        this.$moreButton.parent().removeClass('d-flex').addClass('d-none');
      } else {
        this.$moreButton.parent().removeClass('d-none').addClass('d-flex');
      }

    } else {
      this.$moreButton.toggleClass('loading');
    }
  }

  // Handle load more items
  manageLoadMore() {
    this.$moreButton.on('click', (e) => {
      e.preventDefault();

      this.$moreButton.toggleClass('loading').attr('disabled', true);

      this.data.offset = $('.hentry', this.$grid).length;

      const posts = this.getPosts();

      posts.success((response) => {
        this.handleResponse(response);
      });
    });
  }
}

const loadCases = () => {
  new manageCases();
};

export default loadCases;
