import 'imagesloaded';
import manageImgCover from '../util/imgCover';

class managePosts {

  constructor() {
    this.$grid = $('.posts-wrap');
    this.$moreButton = $('.btn-load-more');
    this.$categoryFilterSelect = $('.content-category-filter select');
    this.globals = window.huxGlobals;
    this.data = {
      action: 'hux_load_posts',
      offset: 0,
      nonce: this.globals.nonce,
      post_type: this.globals.post_type,
      category: null,
      posts_per_page: this.globals.posts_per_page,
    };

    this.manageLoadMore();
    this.manageFilters();
  }

  getPosts() {
    $('.main').addClass('posts-loading');

    return $.ajax({
      method: 'POST',
      url: this.globals.ajax_url,
      dataType: 'json',
      data: this.data,
      success: () => {
        $('.main').removeClass('posts-loading');
      },
    });
  }

  handleResponse(response) {

    if (response.success) {
      const $elems = $(response.data.html);

      $('.alert', this.$grid).remove();

      this.$moreButton.removeClass('loading').attr('disabled', false);

      if (this.data.offset > 0) {
        this.$grid.append($elems);
        $elems.imagesLoaded(() => {
          manageImgCover();
        });
      } else {
        this.$grid.empty();
        this.$grid.append($elems);

        $elems.imagesLoaded(() => {
          manageImgCover();
        });
      }

      if((parseInt(response.data.count) - response.data.args.posts_per_page ) === response.data.offset) {
        this.$moreButton.parent().removeClass('d-flex').addClass('d-none');
      } else {
        this.$moreButton.parent().removeClass('d-none').addClass('d-flex');
      }

    } else {
      this.$moreButton.toggleClass('loading');
    }
  }

  // Handle load more items
  manageLoadMore() {
    this.$moreButton.on('click', (e) => {
      e.preventDefault();

      this.$moreButton.toggleClass('loading').attr('disabled', true);

      this.data.offset = $('.hentry', this.$grid).length;

      const posts = this.getPosts();

      posts.success((response) => {
        this.handleResponse(response);
      });
    });
  }

  manageFilters() {
    this.$categoryFilterSelect.on('change', (e) => {
      e.preventDefault();
      const category = $(e.target).find(':selected').data('post-category');

      if (category !== undefined) {
        this.data.category = category;
      } else {
        this.data.category = null;
      }
      // Reset the offset because we change filters
      this.data.offset = 0;

      const posts = this.getPosts();
      posts.success((response) => {
        this.handleResponse(response);
      });
    });
  }
}

const loadPosts = () => {
  new managePosts();
};

export default loadPosts;
