import 'slick-carousel';

const splitSlider = () => {
  const globals = window.huxGlobals;
  const $slidersContainer = $('.layout-item.split_content');

  $slidersContainer.each((index, container) => {
    const $container = $(container);
    const uid = $(container).data('uid');
    const $textSlider = $('.sc-text-slider', $container);
    const $imageSlider = $('.sc-image-slider', $container);
    const mainSliderArgs = {
      arrows: true,
      dots: false,
      infinite: true,
      slidesToScroll: 1,
      slidesToShow: 1,
      slide: '.sc-text-slider-slide',
      autoplay: $container.data('autoplay') === 'enabled' && !$('body').hasClass('is-mobile'),
      autoplaySpeed: $container.data('interval') ? $container.data('interval') * 1000 : 6000,
      prevArrow: `<a href="#" class="slick-prev" title="${globals.prev}"><i class="hux-icon-chevron-left" aria-hidden="true"></i></a>`,
      nextArrow: `<a href="#" class="slick-next" title="${globals.next}"><i class="hux-icon-chevron-right" aria-hidden="true"></i></a>`,
      appendArrows: `.sc-slider-arrows.${uid}`,
      asNavFor: `.sc-image-slider.${uid}`,
    };
    const childSliderArgs = {
      arrows: false,
      dots: false,
      infinite: true,
      slidesToScroll: 1,
      slidesToShow: 1,
      autoplay: false,
      asNavFor: `.sc-text-slider.${uid}`,
    };

    if ($container.hasClass('both-slider')) {
      $textSlider.slick(mainSliderArgs);
      $imageSlider.slick(childSliderArgs);
    }

    if ($container.hasClass('image-slider')) {
      $imageSlider.slick({
        ...mainSliderArgs,
        slide: '.sc-image-slider-slide',
        asNavFor: null,
      });
    }

    if ($container.hasClass('text-slider')) {
      $textSlider.slick({
        ...mainSliderArgs,
        slide: '.sc-text-slider-slide',
        asNavFor: null,
      });
    }
  });
};

export default splitSlider;
