import Modernizr from 'modernizr';
import 'jquery-sticky';

const manageStickyNavigation = () => {
  const $body = $('body');
  const scrollTop = $(window).scrollTop();
  const offset = $('.banner .bottom').outerHeight();

  if (Modernizr.mq('(min-width: 992px)')) {
    $body.removeClass('scrolled');
    $body.removeClass('sticky-top-active');
  } else {
    if (scrollTop > 0) {
      $body.addClass('scrolled');
    } else {
      $body.removeClass('scrolled');
    }

    if (scrollTop > offset) {
      $body.addClass('sticky-top-active');
    } else {
      $body.removeClass('sticky-top-active');
    }
  }
};

const stickyNavigation = () => {
  const $body = $('body');
  const $sticky = $('.banner .bottom');

  $sticky.sticky({
    topSpacing: 0,
  });

  $sticky.on('sticky-start', () => {
    $body.addClass('sticky-bottom-active');
  });

  $sticky.on('sticky-end', () => {
    $body.removeClass('sticky-bottom-active');
  });


  $(window).on('scroll touchstart touchend swipe', () => {
    manageStickyNavigation();
  });

  $(window).on('resize', () => {
    manageStickyNavigation();
  });
};

export default stickyNavigation;
