import _ from 'lodash';

export const safariFix = () => {
  const isSafari = /^((?!chrome|android|crios|fxios).)*safari/i.test(navigator.userAgent);

  if ($('body').hasClass('is-mobile') && isSafari) {
    $('.layout-item.full-screen-it .full-screen-content, .layout-item.full-screen-it').css({
      'min-height': window.innerHeight,
    });
  }
};

const safariFixDebounced = _.debounce(safariFix, 150);

export default safariFixDebounced;
