@if( have_rows('background_image_content') )
  @while( have_rows('background_image_content') ) @php the_row() @endphp

  @php
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'background-image-conten' . '-' ),
      'title' => get_sub_field( 'title' ),
      'image' => get_sub_field( 'image' ),
      'content' => get_sub_field( 'content' ),
      'background_image' => get_sub_field( 'background_image' ),
      'buttons' => get_sub_field( 'buttons' ),
    ];

    $classes = [
      'layout-item',
      'background_image_content'
    ];
  @endphp

  <section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}">
    @if( ! empty( $fields['background_image'] ) )
      <figure class="bg-thumbnail img-cover mb-0">
        {!! \App\get_responsive_attachment( $fields['background_image'], 'hux-thumbnail-lg' ) !!}
      </figure>
    @endif

    <div class="content-wrap">
      <div class="container">
        <div class="content-inner row">
          <div class="content">
            @if( ! empty( $fields['title'] ) )
              <h4 class="content-title">{!! $fields['title'] !!}</h4>
            @endif

            @if( ! empty( $fields['content'] ) )
              <p class="content-text">{!! $fields['content'] !!}</p>

              @if( ! empty( $fields['image'] ) )
                <figure class="content-image mb-0">
                  {!! \App\get_responsive_attachment( $fields['image'], 'hux-thumbnail-xs' ) !!}
                </figure>
              @endif
            @endif

              @if( ! empty( $fields['buttons'] ) )
                <div class="cb-buttons btn-troop mt-4">
                  @foreach( $fields['buttons'] as $button )
                    {!! \App\the_wpc_button([
                      'data' => $button['button']
                    ]) !!}
                  @endforeach
                </div>
              @endif
          </div>
        </div>
      </div>
    </div>
  </section>

  @endwhile
@endif

