@if( have_rows('banner') )
  @while( have_rows('banner') ) @php the_row() @endphp

  @php
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'banner' . '-' ),
      'title' => get_sub_field( 'title' ),
      'sub_title' => get_sub_field( 'sub_title' ),
      'buttons' => get_sub_field( 'buttons' ),
      'image' => get_sub_field( 'image' ),
      'video' => get_sub_field( 'video' ),
      'fallback_image' => get_sub_field( 'fallback_image' ),
      'background_type' => get_sub_field( 'background_type' ),
      'full_screen' => get_sub_field( 'full_screen' ),
      'title_size' => get_sub_field( 'title_size' ),
    ];

    $classes = [
      'layout-item',
      'banner_page',
      $fields['full_screen'] === 'enabled' ? 'full-screen-it' : ''
    ];
  @endphp

  <section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}">
    @if( $fields['background_type'] === 'image' )
      @if( ! empty( $fields['image'] ) )
        <figure class="banner-thumbnail img-cover mb-0">
          {!! \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-lg' ) !!}
        </figure>
      @endif
    @else
      @if( wp_is_mobile() && $fields['fallback_image'])
        <figure class="banner-thumbnail img-cover mb-0">
          {!! \App\get_responsive_attachment( $fields['fallback_image']['id'], 'hux-thumbnail-lg' ) !!}
        </figure>
      @else
        @if( ! empty( $fields['video'] ) )
          <div class="banner-video">
            <div class="banner-video-foreground">
              <iframe src="{!! $fields['video'] !!}" frameborder="0" allowfullscreen></iframe>
            </div>
          </div>
        @endif
      @endif
    @endif

    <div class="banner-wrap full-screen-content">
      <div class="container">
        <div class="banner-inner full-screen-content">
          <div class="banner-content">
            @if( ! empty( $fields['sub_title'] ) )
              <h3 class="banner-sub-title">{{ $fields['sub_title'] }}</h3>
            @endif

            @if( ! empty( $fields['title'] ) )
              @if( get_row_index() === 1 )
                <h1 class="banner-title {{ $fields['title_size'] }}">{!! $fields['title'] !!}</h1>
              @else
                <h2 class="banner-title {{ $fields['title_size'] }}">{!! $fields['title'] !!}</h2>
              @endif
            @endif

            @if( ! empty( $fields['buttons'] ) )
              <div class="banner-buttons btn-troop-lg">
                @foreach( $fields['buttons'] as $button )
                  {!! \App\the_wpc_button([
                    'data' => $button['button'],
                    'classes' => [ 'btn', 'btn-lg' ],
                  ]) !!}
                @endforeach
              </div>
            @endif
          </div>
        </div>
      </div>
    </div>

    <div class="banner-anchor-wrap">
      <a href="#main-content" class="banner-anchor scrool-to" title="{{ __( 'Skip to content', 'hux' ) }}">
        <i class="banner-anchor-icon hux-icon-chevron-down"></i>
        <span class="sr-only">{{ __( 'Skip to content', 'hux' ) }}</span>
      </a>
    </div>
  </section>

  @endwhile
@endif

