@if( have_rows('content_block') )
  @while( have_rows('content_block') ) @php the_row() @endphp

  @php
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'content_block' . '-' ),
      'title' => get_sub_field( 'title' ),
      'sub_title' => get_sub_field( 'sub_title' ),
      'text' => get_sub_field( 'text' ),
      'buttons' => get_sub_field( 'buttons' ),
      'background' => get_sub_field( 'background' ),
      'icon' => get_sub_field( 'icon' ),
      'padding' => get_sub_field( 'content_block_padding' ),
    ];

    $classes = [
      'layout-item',
      'content_block',
      $fields['background'],
      'pt-' . $fields['padding']['top'],
      'pb-' . $fields['padding']['bottom']
    ];

    if( \App\layout_has_bg( $fields['background'] ) ) {
      $classes[] = 'has-bg';
    }
  @endphp

  @if( ! empty( $fields['title'] ) || ! empty( $fields['sub_title'] ) || ! empty( $fields['text'] ) || ! empty( $fields['buttons'] || ! empty( $fields['icon'] ) ) )
    <section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}">
      <div class="container">
        <div class="cb-content">
          @if( ! empty( $fields['icon'] ) )
            <i class="cb-icon {{ $fields['icon'] }}"></i>
          @endif

          @if( ! empty( $fields['sub_title'] ) )
            <h4 class="cb-sub-title">{{ $fields['sub_title'] }}</h4>
          @endif

          @if( ! empty( $fields['title'] ) )
            <h3 class="cb-title">{{ $fields['title'] }}</h3>
          @endif

          @if( ! empty( $fields['text'] ) )
            <div class="cb-text rlpm">
              {!! $fields['text'] !!}
            </div>
          @endif

          @if( ! empty( $fields['buttons'] ) )
            <div class="cb-buttons btn-troop">
              @foreach( $fields['buttons'] as $button )
                {!! \App\the_wpc_button([
                  'data' => $button['button']
                ]) !!}
              @endforeach
            </div>
          @endif
        </div>
      </div>
    </section>
  @endif

  @endwhile
@endif
