@php
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( get_row_layout() . '-' ),
    'offices' =>  get_sub_field('offices'),
  ];

  $thumbnailAnim = array(
    'animation' => 'fade',
    'delay'     => 0.1,
    'duration'  => 1,
    'easing'    => '',
    'anchor'    => ''
);

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
@endphp

<section id="{{ $fields['layout_id'] }}" class="layout-item {{  get_row_layout() }}">
  <div class="container">
    @foreach($fields['offices'] as $office)
      <div class="office-item" <?= \App\get_the_aos($contentAnim); ?>>
        @if( ! empty( $thumbnail = $office['image'] ) )

          <div class="row align-items-md-center">
            <div class="col-md-8">
              @if( ! empty( $office['image'] ) )

                <figure class="post-thumbnail img-cover mb-0" <?= \App\get_the_aos($thumbnailAnim); ?>>
                  {!! \App\get_responsive_attachment( $office['image'], 'hux-thumbnail-md' ) !!}
                </figure>

              @endif
            </div>

            <div class="col-md-4">
              <div class="post-content">
                @if( ! empty( $title = $office['title'] ) )
                  <h4 class="post-title">
                    {{ $title }}
                  </h4>
                @endif

                @if(! empty($text = $office['text']) )
                  <div class="post-text">
                    {!! $text !!}
                  </div>
                @endif

                @if( ! empty( $email = $office['email'] ) )
                  <a href="mail:{{ $email }}" rel="nofollow" class="post-email"
                     title="{{ __('Email Us', 'hux') }}">{{ $email }}</a>
                @endif

                @if( ! empty( $location = $office['location'] ) )
                  <div class="post-buttons">
                    <a class="btn btn-primary"
                       href="http://maps.google.com/?q={{ $location['lat'] }},{{ $location['lng'] }}" target="_blank"
                       rel="nofollow">{{ __('View on map', 'hux') }}</a>
                  </div>
                @endif

              </div>
            </div>
          </div>
        @endif
      </div>

    @endforeach
  </div>
</section>

