@php
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( get_row_layout() . '-' ),
    'properties' =>  get_sub_field('properties')
  ];

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
@endphp

<section id="{{ $fields['layout_id'] }}" class="layout-item {{  get_row_layout() }}">
  <div class="properties">
    @foreach($fields['properties'] as $p)
      <div class="property">
        <a href="{{ get_permalink( $p['property']->ID ) }}" title=" {{ get_the_title($p['property'] ) }}">
          @if( ! empty( $image = $p['image'] ) )
            <figure class="property-thumbnail img-cover mb-0">
              {!! \App\get_responsive_attachment( $image, 'hux-thumbnail-lg' ) !!}
            </figure>
          @endif

          <div class="property-content">
            <h4 class="property-title">
              @php($region = wp_get_post_terms( $p['property']->ID, 'region', array('fields' => 'names') ))

              @if( ! empty( $region ) )
                <span>{{ $region[0] }}</span>
              @endif
              {{ get_the_title($p['property'] ) }}
            </h4>
            @if( get_field ('single_price',  $p['property']->ID )  && ! empty( $price = get_field( 'property_price', $p['property']->ID ) ))
              <span class="property-price single">{!! \App\generate_price($price, 'none', 'code') !!}</span>
            @endif

            @if( ! get_field ('single_price',  $p['property']->ID ) && ! empty( $priceFrom = get_field( 'property_price_from', $p['property']->ID ) )
             && ! empty( $priceTo = get_field( 'property_price_to', $p['property']->ID ) ))
              <div class="property-price multiple">{!! \App\generate_price($priceFrom, 'none', 'none') !!}
                - {!! \App\generate_price($priceTo, 'none', 'code') !!}</div>
            @endif

            @if(! empty($excerpt = $p['text']))
              <div class="property-text mt-2">
                {!! $excerpt !!}
              </div>
            @endif


            <div class="property-buttons mt-4">
              <button class="btn btn-white">{{ __('View Property', 'hux') }}</button>
            </div>
          </div>
        </a>
      </div>
    @endforeach
  </div>
</section>
