@if( have_rows('split_content') )
  @while( have_rows('split_content') ) @php the_row() @endphp

  @php
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'split_content' . '-' ),
      'uid' => uniqid( 'split_content' . '-' ),
      'title' => get_sub_field( 'title' ),
      'text' => get_sub_field( 'text' ),
      'image' => get_sub_field( 'image' ),
      'slider_type' => get_sub_field( 'slider_type' ),
      'slider_settings' => get_sub_field( 'split_content_slider_settings' ),
      'order' => get_sub_field( 'order' ),
      'slides' => get_sub_field( 'slides' ),
      'buttons' => get_sub_field( 'buttons' ),
    ];

    $classes = [
      'layout-item',
      'split_content',
      $fields['slider_type'],
    ];

  $datas = [];

  if($fields['slider_type'] !== 'no-slider') {
  $datas = [
      'data-uid='.$fields['uid'],
      'data-autoplay='.$fields['slider_settings']['autoplay'],
      'data-interval='.$fields['slider_settings']['interval'],
  ];
  }

  @endphp

  <section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}" {{ implode( ' ', $datas ) }}>

    <div class="row ml-0 mr-0 {{ $fields['order'] }}">
      <div class="col-md-6 pl-0 pr-0 pos-rel">
        @if( ! empty( $fields['image'] ) && ( $fields['slider_type'] !== 'image-slider' && $fields['slider_type'] !== 'both-slider' ))
          <figure class="sc-thumbnail img-cover mb-0">
            {!! \App\get_responsive_attachment( $fields['image'], 'hux-thumbnail' ) !!}
          </figure>
        @else
          <div class="sc-image-slider {{ $fields['uid'] }}">
            @foreach($fields['slides'] as $slide)
              <div class="sc-image-slider-slide">
                <figure class="sc-thumbnail img-cover mb-0">
                  {!! \App\get_responsive_attachment( $slide['image'], 'hux-thumbnail' ) !!}
                </figure>
              </div>
            @endforeach
          </div>
        @endif
        @if($fields['slider_type'] !== 'no-slider' )
          <div class="sc-slider-arrows {{ $fields['uid'] }}"></div>
        @endif
      </div>

      <div class="col-md-6 pl-0 pr-0 d-flex justify-content-center align-items-center">
        <div class="sc-wrap">
          @if($fields['slider_type'] !== 'both-slider' && $fields['slider_type'] !== 'text-slider')
            <div class="sc-item">
              @if( ! empty( $fields['title'] ) )
                <h3 class="sc-title">{{ $fields['title'] }}</h3>
              @endif

              @if( ! empty( $text = get_sub_field( 'text' ) ) )
                <div class="sc-text">{!! $text !!}</div>
              @endif
            </div>
          @else
            <div class="sc-text-slider {{ $fields['uid'] }}">
              @foreach($fields['slides'] as $slide)
                <div class="sc-item sc-text-slider-slide">
                  @if( ! empty( $slide['title'] ) )
                    <h3 class="sc-title">{{ $slide['title'] }}</h3>
                  @endif

                  @if( ! empty( $text = $slide['text'] ) )
                    <div class="sc-text">{!! $text !!}</div>
                  @endif
                </div>
              @endforeach
            </div>
          @endif
          @if( ! empty( $fields['buttons'] ) )
            <div class="sc-buttons mt-4">
              @foreach( $fields['buttons'] as $button )
                {!! \App\the_wpc_button([
                  'data' => $button['button']
                ]) !!}
              @endforeach
            </div>
          @endif
        </div>
      </div>
    </div>
  </section>

  @endwhile
@endif
