@php
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( get_row_layout() . '-' ),
    'why_us' =>  get_sub_field('why_us'),
    'padding' => get_sub_field( 'why_us_padding' ),
  ];

  $classes = [
    'layout-item',
    'why_us',
    'pt-' . $fields['padding']['top'],
    'pb-' . $fields['padding']['bottom']
  ];
@endphp

<section id="{{ $fields['layout_id'] }}" class="{{ implode( ' ', $classes ) }}">
  <div class="container">
    <div class="row why_us_block">
      @if( ! empty( $fields['why_us'] ) )
        @foreach($fields['why_us'] as $wu)
          <div class="col-sm-3">
            @if( ! empty( $icon = $wu['icon'] ) )
              <span class="wu-icon">{!! $icon !!}</span>
            @endif
            @if( ! empty( $wu['subtitle'] ) )
              <span class="wu-subtitle">{{ $wu['subtitle'] }}</span>
            @endif
            @if( ! empty( $wu['title'] ) && !$wu['is_price'])
              <h4 class="wu-title">{!! $wu['title'] !!}</h4>
            @endif
              @if( ! empty($price = $wu['price'] ) && $wu['is_price'])
                <span class="wu-title">{!! \App\generate_price($price) !!}</span>
              @endif
          </div>
        @endforeach
      @endif
    </div>
  </div>
</section>
