@php
  $cr = get_field( 'cr', 'option' );
@endphp

@if( ! empty( $title = $cr['title'] ) )
  <h3 class="title text-center">{{ $title }}</h3>
@endif
@if( ! empty( $description = $cr['content'] ) )
  <p class="description text-center mb-3">{!!  $description !!}</p>
@endif

<form>

  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon">{{ __('Property value', 'hux') }}  {!! App\generate_currency_signs() !!}</span>
    <input type="number" class="form-control" id="property_value">
  </div>

  <div class="input-group input-group-custom input-group-lg">
    <span
      class="input-group-addon">{{ __('Monthly rental income', 'hux') }}  {!! App\generate_currency_signs() !!}</span>
    <input type="number" class="form-control" id="monthly_income">
  </div>

  <p class="validation_error d-none y">{{ __('Please Fill in All Fields', 'hux') }}</p>

  <div class="d-flex justify-content-center mt-3">
    <button class="btn btn-primary btn-return" type="submit">{{ __('Calculate return', 'hux') }}</button>
  </div>
  <div class="yield-result d-none mt-3">
    <p>
      <span class="title">{{ __('gross annual rent income', 'hux') }}</span>
      {!! App\generate_currency_signs() !!}<span id="gross-annual"></span>
    </p>
    <p>
      <span class="title">{{ __('net annual income minus service costs at 10%', 'hux') }}</span>
      {!! App\generate_currency_signs() !!}<span id="net-annual"></span>
    </p>
    <p>
      <span class="title">{{ __('cash buyer net yield p.a', 'hux') }}</span>
      <span id="c-net-yield"></span>%
    </p>
    <p>
      <span class="title">{{ __('leveraged buyer net yield pa (ie mortgaged at 70%)', 'hux') }}</span>
      <span id="l-net-yield"></span>%
    </p>
  </div>
</form>
