@php
  $post_categories = get_terms( 'category', array(
    'hide_empty' => true,
  ) );
@endphp

@if( ! empty( $post_categories ) )
  <section class="layout-item content-category-filter">

    <div class="container">
      <div class="select gform_wrapper">
        <select class="custom-select form-control form-control-lg">
          <option>{{ __('Filter articles', 'hux') }}</option>

          @foreach( $post_categories as $post_category )
            <option data-post-category="{{ $post_category->slug }}">{{ $post_category->name }}</option>
          @endforeach
        </select>
      </div>
    </div>
  </section>
@endif
