@php
  $fields = [
    'title' => get_field( 'title', get_the_ID() ),
    'sub_title' => get_field( 'sub_title', get_the_ID() ),
    'text' => get_field( 'text', get_the_ID() ),
    'image' => get_field( 'thumbnail', get_the_ID() ),
  ];

  $image_max_height = empty( $fields['image']['sizes']['hux-thumbnail-sm-height'] ) ? false : $fields['image']['sizes']['hux-thumbnail-sm-height'];
  $image_ratio = ( $fields['image']['height'] / $fields['image']['width'] ) * 100;

$thumbnailAnim = array(
  'animation' => 'fade',
  'delay'     => 0,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
@endphp

<div class="featured-wrap" <?= \App\get_the_aos($contentAnim); ?>>
  <div class="container">
    <article @php(post_class())>
      @if( ! empty( $thumbnail = get_field( 'thumbnail', get_the_ID() ) ) )
        @php($terms = get_the_terms( get_the_ID(), 'category'))

        <div class="row align-items-md-center">
          <div class="col-md-8">
            @if( ! empty( $fields['image'] ) )
              <a href="{{ get_permalink() }}" title="{{ get_the_title() }}" class="post-link">
                <figure class="post-thumbnail img-cover mb-0" data-min="768"
                        style="padding-top: {{ absint( $image_ratio ) }}%; {{ empty( $image_max_height ) ? '' : 'min-height: ' . $image_max_height  . 'px' }}" <?= \App\get_the_aos($thumbnailAnim); ?>>
                  {!! \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-md' ) !!}
                </figure>
              </a>
            @endif
          </div>

          <div class="col-md-4">
            <div class="post-content">

              @if( ! empty( $icon = get_field('icon', $terms[0] ) ) )
                <span class="post-icon">{!! $icon !!}</span>
              @endif

              @if( ! empty( $category = $terms[0] ) )
                <span class="post-category">{{ $category->name }}</span>
              @endif

              <h4 class="post-title">
                {{ get_the_title() }}
              </h4>

              @if(! empty($excerpt = get_field('excerpt', get_the_ID())) )
                <div class="post-text">
                  {{ $excerpt }}
                </div>
              @endif


              <div class="post-buttons">
                <a href="{{ get_permalink() }}" class="btn btn-primary">{{ __('Read more', 'hux') }}</a>
              </div>

            </div>
          </div>
        </div>
      @endif
    </article>
  </div>
</div>
