@php
  $fields = [
    'title' => get_field( 'title', get_the_ID() ),
    'image' => get_field( 'thumbnail', get_the_ID() ),
    'region' => wp_get_post_terms( get_the_ID(), 'region', array('fields' => 'names') ),
  ];

$thumbnailAnim = array(
  'animation' => 'fade',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
@endphp


<article @php(post_class()) <?= \App\get_the_aos($contentAnim); ?>>
  @if( ! empty( $thumbnail = get_field( 'thumbnail', get_the_ID() ) ) )

    <div class="row align-items-md-center">
      <div class="col-md-8">
        @if( ! empty( $fields['image'] ) )
          @if(get_field('is_video', get_the_ID()))
            <a href="{{ get_field('video_url', get_the_ID()) }}" class="video-link link">
              <i class="hux-icon-play" aria-hidden="true"></i>
          @endif
              <figure class="post-thumbnail img-cover mb-0" <?= \App\get_the_aos($thumbnailAnim); ?>>
                {!! \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-md' ) !!}
              </figure>
          @if(get_field('is_video', get_the_ID()))
            </a>
          @endif
        @endif
      </div>

      <div class="col-md-4">
        <div class="post-content">
          <h4 class="post-title">
            {{ get_the_title() }}

            @if( ! empty( $fields['region'] ) )
              <span>{{ $fields['region'][0] }}</span>
            @endif
          </h4>

          @if(! empty($excerpt = get_field('excerpt', get_the_ID())) )
            <div class="post-text">
              {!! $excerpt !!}
            </div>
          @endif


          <div class="post-buttons">
            @if(get_field('is_video', get_the_ID()))
              <a href="{{ get_field('video_url', get_the_ID()) }}"
                 class="btn btn-primary video-link">{{ __('Watch video', 'hux') }}</a>
            @else
              <a href="{{ get_permalink() }}" class="btn btn-primary">{{ __('Read more', 'hux') }}</a>
            @endif
          </div>

        </div>
      </div>
    </div>
  @endif
</article>
