@php
  $fields = [
    'title' => get_field( 'title', get_the_ID() ),
    'image' => get_field( 'thumbnail', get_the_ID() ),
    'region' => wp_get_post_terms( get_the_ID(), 'region', array('fields' => 'names') ),
  ];

$thumbnailAnim = array(
  'animation' => 'fade',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
@endphp


<article @php(post_class()) <?= \App\get_the_aos($contentAnim); ?>>
  @if( ! empty( $thumbnail = get_field( 'thumbnail', get_the_ID() ) ) )

    <div class="row align-items-md-center">
      <div class="col-md-8">
        @if( ! empty( $fields['image'] ) )
          <a href="{{ get_permalink() }}" class="property-link" title="{{ get_the_title() }}">
            <figure class="property-thumbnail img-cover mb-0" <?= \App\get_the_aos($thumbnailAnim); ?>>
              {!! \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-md' ) !!}
            </figure>
          </a>
        @endif
      </div>

      <div class="col-md-4">
        <div class="property-content">
          <h4 class="property-title">
            @if( ! empty( $fields['region'] ) )
              <span>{{ $fields['region'][0] }}</span>
            @endif
            {{ get_the_title() }}
          </h4>
          @if( get_field ('single_price',  get_the_ID() )  && ! empty( $price = get_field( 'property_price', get_the_ID() ) ))
            <span class="property-price single">{!! \App\generate_price($price, 'none', 'code') !!}</span>
          @endif

          @if( ! get_field ('single_price',  get_the_ID() ) && ! empty( $priceFrom = get_field( 'property_price_from', get_the_ID() ) )
           && ! empty( $priceTo = get_field( 'property_price_to', get_the_ID() ) ))
            <div class="property-price multiple">{!! \App\generate_price($priceFrom, 'none', 'none') !!}
              - {!! \App\generate_price($priceTo, 'none', 'code') !!}</div>
          @endif

          @if(! empty($excerpt = get_field('excerpt', get_the_ID())) )
            <div class="property-text">
              {!! $excerpt !!}
            </div>
          @endif


          <div class="property-buttons">
            <a href="{{ get_permalink() }}" class="btn btn-primary">{{ __('View Property', 'hux') }}</a>
          </div>
        </div>
      </div>
    </div>
  @endif
</article>
