@php
  $thumbnail = get_field( 'thumbnail', get_the_ID() );
  $terms = get_the_terms( get_the_ID(), 'category');
@endphp

<article @php(post_class("ptc-slide"))>
  <div class="ptc-slide-inner">
    <div class="ptc-slide-content eh-child">
      <div class="ptc-button">
        <a class="btn btn-primary" href="{{ get_the_permalink() }}" title="{{ __( 'Read more', 'hux' ) }}">
          {{ __( 'Read more', 'hux' ) }}
        </a>
      </div>

      <h4 class="ptc-slide-title">
        {{ get_the_title() }}
      </h4>

      @if( ! empty( $category = $terms[0] ) )
        <span class="ptc-category">{{ $category->name }}</span>
      @endif

      @if( ! empty( $icon = get_field('icon', $terms[0] ) ) )
        <span class="ptc-icon">{!! $icon !!}</span>
      @endif
    </div>
    <a class="ptc-slide-thumbnail mt-0 bg-cover eh-child" href="{{ get_the_permalink() }}"
       title="{{ __( 'Read more', 'hux' ) }}"
       style="background-image: url({{ $thumbnail['sizes']['hux-thumbnail'] }})"></a>
  </div>
</article>
