<?php if( have_rows('banner') ): ?>
  <?php while( have_rows('banner') ): ?> <?php  the_row()  ?>

  <?php 
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'banner' . '-' ),
      'title' => get_sub_field( 'title' ),
      'sub_title' => get_sub_field( 'sub_title' ),
      'buttons' => get_sub_field( 'buttons' ),
      'image' => get_sub_field( 'image' ),
      'video' => get_sub_field( 'video' ),
      'fallback_image' => get_sub_field( 'fallback_image' ),
      'background_type' => get_sub_field( 'background_type' ),
      'full_screen' => get_sub_field( 'full_screen' ),
      'title_size' => get_sub_field( 'title_size' ),
    ];

    $classes = [
      'layout-item',
      'banner_page',
      $fields['full_screen'] === 'enabled' ? 'full-screen-it' : ''
    ];
   ?>

  <section id="<?php echo e($fields['layout_id']); ?>" class="<?php echo e(implode( ' ', $classes )); ?>">
    <?php if( $fields['background_type'] === 'image' ): ?>
      <?php if( ! empty( $fields['image'] ) ): ?>
        <figure class="banner-thumbnail img-cover mb-0">
          <?php echo \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-lg' ); ?>

        </figure>
      <?php endif; ?>
    <?php else: ?>
      <?php if( wp_is_mobile() && $fields['fallback_image']): ?>
        <figure class="banner-thumbnail img-cover mb-0">
          <?php echo \App\get_responsive_attachment( $fields['fallback_image']['id'], 'hux-thumbnail-lg' ); ?>

        </figure>
      <?php else: ?>
        <?php if( ! empty( $fields['video'] ) ): ?>
          <div class="banner-video">
            <div class="banner-video-foreground">
              <iframe src="<?php echo $fields['video']; ?>" frameborder="0" allowfullscreen></iframe>
            </div>
          </div>
        <?php endif; ?>
      <?php endif; ?>
    <?php endif; ?>

    <div class="banner-wrap full-screen-content">
      <div class="container">
        <div class="banner-inner full-screen-content">
          <div class="banner-content">
            <?php if( ! empty( $fields['sub_title'] ) ): ?>
              <h3 class="banner-sub-title"><?php echo e($fields['sub_title']); ?></h3>
            <?php endif; ?>

            <?php if( ! empty( $fields['title'] ) ): ?>
              <?php if( get_row_index() === 1 ): ?>
                <h1 class="banner-title <?php echo e($fields['title_size']); ?>"><?php echo $fields['title']; ?></h1>
              <?php else: ?>
                <h2 class="banner-title <?php echo e($fields['title_size']); ?>"><?php echo $fields['title']; ?></h2>
              <?php endif; ?>
            <?php endif; ?>

            <?php if( ! empty( $fields['buttons'] ) ): ?>
              <div class="banner-buttons btn-troop-lg">
                <?php $__currentLoopData = $fields['buttons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php echo \App\the_wpc_button([
                    'data' => $button['button'],
                    'classes' => [ 'btn', 'btn-lg' ],
                  ]); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>

    <div class="banner-anchor-wrap">
      <a href="#main-content" class="banner-anchor scrool-to" title="<?php echo e(__( 'Skip to content', 'hux' )); ?>">
        <i class="banner-anchor-icon hux-icon-chevron-down"></i>
        <span class="sr-only"><?php echo e(__( 'Skip to content', 'hux' )); ?></span>
      </a>
    </div>
  </section>

  <?php endwhile; ?>
<?php endif; ?>

