<?php 
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( get_row_layout() . '-' ),
    'properties' =>  get_sub_field('properties')
  ];

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
 ?>

<section id="<?php echo e($fields['layout_id']); ?>" class="layout-item <?php echo e(get_row_layout()); ?>">
  <div class="properties">
    <?php $__currentLoopData = $fields['properties']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="property">
        <a href="<?php echo e(get_permalink( $p['property']->ID )); ?>" title=" <?php echo e(get_the_title($p['property'] )); ?>">
          <?php if( ! empty( $image = $p['image'] ) ): ?>
            <figure class="property-thumbnail img-cover mb-0">
              <?php echo \App\get_responsive_attachment( $image, 'hux-thumbnail-lg' ); ?>

            </figure>
          <?php endif; ?>

          <div class="property-content">
            <h4 class="property-title">
              <?php ($region = wp_get_post_terms( $p['property']->ID, 'region', array('fields' => 'names') )); ?>

              <?php if( ! empty( $region ) ): ?>
                <span><?php echo e($region[0]); ?></span>
              <?php endif; ?>
              <?php echo e(get_the_title($p['property'] )); ?>

            </h4>
            <?php if( get_field ('single_price',  $p['property']->ID )  && ! empty( $price = get_field( 'property_price', $p['property']->ID ) )): ?>
              <span class="property-price single"><?php echo \App\generate_price($price, 'none', 'code'); ?></span>
            <?php endif; ?>

            <?php if( ! get_field ('single_price',  $p['property']->ID ) && ! empty( $priceFrom = get_field( 'property_price_from', $p['property']->ID ) )
             && ! empty( $priceTo = get_field( 'property_price_to', $p['property']->ID ) )): ?>
              <div class="property-price multiple"><?php echo \App\generate_price($priceFrom, 'none', 'none'); ?>

                - <?php echo \App\generate_price($priceTo, 'none', 'code'); ?></div>
            <?php endif; ?>

            <?php if(! empty($excerpt = $p['text'])): ?>
              <div class="property-text mt-2">
                <?php echo $excerpt; ?>

              </div>
            <?php endif; ?>


            <div class="property-buttons mt-4">
              <button class="btn btn-white"><?php echo e(__('View Property', 'hux')); ?></button>
            </div>
          </div>
        </a>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</section>
