<?php 
  $cr = get_field( 'cp', 'option' );
 ?>

<?php if( ! empty( $title = $cr['title'] ) ): ?>
  <h3 class="title text-center"><?php echo e($title); ?></h3>
<?php endif; ?>
<?php if( ! empty( $description = $cr['content'] ) ): ?>
  <p class="description text-center mb-3"><?php echo $description; ?></p>
<?php endif; ?>

<form>
  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon"><?php echo e(__('Purchase price', 'hux')); ?>  <?php echo App\generate_currency_signs(); ?></span>
    <input type="text" class="form-control" id="purchase_price">
  </div>

  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon"><i><?php echo e(__('LTV % you wish to borrow', 'hux')); ?></i> <span class="line"></span></span>
    <select class="form-control form-control-lg" id="ltv">
      <?php $__currentLoopData = $cr['ltv']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ltv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e(strtolower($ltv['option'])); ?>"><?php echo e($ltv['option']); ?>%</option>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
  </div>

  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon"><i><?php echo e(__('Interest rate', 'hux')); ?></i> <span class="line"></span></span>
    <select class="form-control form-control-lg" id="interest_rate">
      <?php $__currentLoopData = $cr['interest_rate']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ltv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e(strtolower($ltv['option'])); ?>"><?php echo e($ltv['option']); ?>%</option>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
  </div>

  <div class="input-group input-group-custom input-group-lg">
    <span class="input-group-addon"><i><?php echo e(__('Term length', 'hux')); ?></i> <span class="line"></span></span>
    <select class="form-control form-control-lg" id="term_length">
      <?php $__currentLoopData = $cr['term_length']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ltv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e(strtolower($ltv['option'])); ?>"><?php echo e($ltv['option']); ?> <?php echo e(__('years', 'hux')); ?></option>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
  </div>

  <p class="validation_error d-none y"><?php echo e(__('Please Fill in All Fields', 'hux')); ?></p>

  <div class="d-flex justify-content-center mt-3">
    <button class="btn btn-primary btn-payments" type="submit"><?php echo e(__('calculate payments', 'hux')); ?></button>
  </div>
  <div class="capital-result d-none mt-3">
    <p>
      <span class="title"><?php echo e(__('borrowing amount', 'hux')); ?></span>
      <?php echo App\generate_currency_signs(); ?><span id="borrowing-amount"></span>
    </p>
    <p>
      <span class="title"><?php echo e(__('Monthly mortgage payments', 'hux')); ?></span>
      <?php echo App\generate_currency_signs(); ?><span id="monthly-mortgage"></span>
    </p>
  </div>
</form>
