<?php 
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( get_row_layout() . '-' ),
    'offices' =>  get_sub_field('offices'),
  ];

  $thumbnailAnim = array(
    'animation' => 'fade',
    'delay'     => 0.1,
    'duration'  => 1,
    'easing'    => '',
    'anchor'    => ''
);

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0.1,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
 ?>

<section id="<?php echo e($fields['layout_id']); ?>" class="layout-item <?php echo e(get_row_layout()); ?>">
  <div class="container">
    <?php $__currentLoopData = $fields['offices']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $office): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="office-item" <?= \App\get_the_aos($contentAnim); ?>>
        <?php if( ! empty( $thumbnail = $office['image'] ) ): ?>

          <div class="row align-items-md-center">
            <div class="col-md-8">
              <?php if( ! empty( $office['image'] ) ): ?>

                <figure class="post-thumbnail img-cover mb-0" <?= \App\get_the_aos($thumbnailAnim); ?>>
                  <?php echo \App\get_responsive_attachment( $office['image'], 'hux-thumbnail-md' ); ?>

                </figure>

              <?php endif; ?>
            </div>

            <div class="col-md-4">
              <div class="post-content">
                <?php if( ! empty( $title = $office['title'] ) ): ?>
                  <h4 class="post-title">
                    <?php echo e($title); ?>

                  </h4>
                <?php endif; ?>

                <?php if(! empty($text = $office['text']) ): ?>
                  <div class="post-text">
                    <?php echo $text; ?>

                  </div>
                <?php endif; ?>

                <?php if( ! empty( $email = $office['email'] ) ): ?>
                  <a href="mail:<?php echo e($email); ?>" rel="nofollow" class="post-email"
                     title="<?php echo e(__('Email Us', 'hux')); ?>"><?php echo e($email); ?></a>
                <?php endif; ?>

                <?php if( ! empty( $location = $office['location'] ) ): ?>
                  <div class="post-buttons">
                    <a class="btn btn-primary"
                       href="http://maps.google.com/?q=<?php echo e($location['lat']); ?>,<?php echo e($location['lng']); ?>" target="_blank"
                       rel="nofollow"><?php echo e(__('View on map', 'hux')); ?></a>
                  </div>
                <?php endif; ?>

              </div>
            </div>
          </div>
        <?php endif; ?>
      </div>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</section>

