<header class="banner">
  <div class="top">
    <div class="container">
      <div class="top-inner d-flex">
        <a class="brand" href="<?php echo e(home_url('/')); ?>" title="<?php echo e(get_bloginfo('name', 'display')); ?>">
          <i class="hux-icon-logo" aria-hidden="true"></i>
        </a>

        <div class="socials d-flex ml-lg-auto">
          <?php echo $__env->make('partials.social-media-links', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>

        <ul class="top-buttons d-flex ml-auto ml-lg-2">
          <?php echo $__env->make('partials.switchers', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
          <li class="ml-auto d-lg-none">
            <a href="#" class="mobile-nav-toggle" data-toggle="mobile-nav">
              <?php echo e(__( 'Menu', 'hux' )); ?>

              <i></i>
            </a>
          </li>
        </ul>
      </div>
    </div>
  </div>

  <div class="bottom d-none d-lg-block">
    <div class="container">
      <div class="bottom-inner d-flex">
        <a class="brand" href="<?php echo e(home_url('/')); ?>" title="<?php echo e(get_bloginfo('name', 'display')); ?>">
          <i class="hux-icon-logo" aria-hidden="true"></i>
        </a>

        <nav class="nav-primary ml-auto">
          <?php 
            if ( has_nav_menu( 'primary_navigation' ) ) :
              wp_nav_menu( [
                'theme_location' => 'primary_navigation',
                'menu_class' => 'nav',
                'link_before' => '<span>',
                'link_after' => '</span>'
              ] );
            endif;
           ?>
        </nav>
      </div>
    </div>
  </div>

  <div class="middle">
    <div class="container">
      <div class="middle-inner">
        <a class="brand" href="<?php echo e(home_url('/')); ?>" title="<?php echo e(get_bloginfo('name', 'display')); ?>">
          <span class="primary"><?php echo wpc_get_the_logo_html();; ?></span>
          <span class="secondary"><?php echo wpc_get_the_logo_html( 'secondary' );; ?></span>
        </a>
      </div>
    </div>
  </div>

  <div class="mobile-nav" id="mobile-nav">
    <div class="mobile-nav-content">
      <nav class="nav-mobile">
        <?php 
          if ( has_nav_menu( 'mobile_navigation' ) ) :
            wp_nav_menu( [
              'theme_location' => 'mobile_navigation',
              'menu_class' => 'nav flex-column',
              'link_before' => '<span>',
              'link_after' => '</span>'
            ] );
          endif;
         ?>
      </nav>
    </div>
  </div>
</header>
