<?php 
  $fields = [
    'title' => get_field( 'title', get_the_ID() ),
    'sub_title' => get_field( 'sub_title', get_the_ID() ),
    'text' => get_field( 'text', get_the_ID() ),
    'image' => get_field( 'thumbnail', get_the_ID() ),
  ];

  $image_max_height = empty( $fields['image']['sizes']['hux-thumbnail-sm-height'] ) ? false : $fields['image']['sizes']['hux-thumbnail-sm-height'];
  $image_ratio = ( $fields['image']['height'] / $fields['image']['width'] ) * 100;

$thumbnailAnim = array(
  'animation' => 'fade',
  'delay'     => 0,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);

$contentAnim = array(
  'animation' => 'fade-up',
  'delay'     => 0,
  'duration'  => 1,
  'easing'    => '',
  'anchor'    => ''
);
 ?>

<div class="featured-wrap" <?= \App\get_the_aos($contentAnim); ?>>
  <div class="container">
    <article <?php (post_class()); ?>>
      <?php if( ! empty( $thumbnail = get_field( 'thumbnail', get_the_ID() ) ) ): ?>
        <?php ($terms = get_the_terms( get_the_ID(), 'category')); ?>

        <div class="row align-items-md-center">
          <div class="col-md-8">
            <?php if( ! empty( $fields['image'] ) ): ?>
              <a href="<?php echo e(get_permalink()); ?>" title="<?php echo e(get_the_title()); ?>" class="post-link">
                <figure class="post-thumbnail img-cover mb-0" data-min="768"
                        style="padding-top: <?php echo e(absint( $image_ratio )); ?>%; <?php echo e(empty( $image_max_height ) ? '' : 'min-height: ' . $image_max_height  . 'px'); ?>" <?= \App\get_the_aos($thumbnailAnim); ?>>
                  <?php echo \App\get_responsive_attachment( $fields['image']['id'], 'hux-thumbnail-md' ); ?>

                </figure>
              </a>
            <?php endif; ?>
          </div>

          <div class="col-md-4">
            <div class="post-content">

              <?php if( ! empty( $icon = get_field('icon', $terms[0] ) ) ): ?>
                <span class="post-icon"><?php echo $icon; ?></span>
              <?php endif; ?>

              <?php if( ! empty( $category = $terms[0] ) ): ?>
                <span class="post-category"><?php echo e($category->name); ?></span>
              <?php endif; ?>

              <h4 class="post-title">
                <?php echo e(get_the_title()); ?>

              </h4>

              <?php if(! empty($excerpt = get_field('excerpt', get_the_ID())) ): ?>
                <div class="post-text">
                  <?php echo e($excerpt); ?>

                </div>
              <?php endif; ?>


              <div class="post-buttons">
                <a href="<?php echo e(get_permalink()); ?>" class="btn btn-primary"><?php echo e(__('Read more', 'hux')); ?></a>
              </div>

            </div>
          </div>
        </div>
      <?php endif; ?>
    </article>
  </div>
</div>
