<?php if( have_rows('post_type_carousel') ): ?>
  <?php while( have_rows('post_type_carousel') ): ?> <?php  the_row()  ?>

  <?php 
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'post_type_carousel' . '-' ),
      'post_type' => get_sub_field( 'post_type' ),
      'posts_to_show' => get_sub_field( 'posts_to_show' ),
      'posts_per_page' => get_sub_field( 'posts_per_page' ),
      'orderby' => get_sub_field( 'orderby' ),
      'order' => get_sub_field( 'order' ),
      'buttons' => get_sub_field( 'buttons' ),
      'background' => get_sub_field( 'background' ),
      'padding' => get_sub_field( 'post_type_carousel_padding' ),
      'slider_settings' => get_sub_field( 'post_type_carousel_slider_settings' ),
    ];

    $classes = [
      'layout-item',
      'post_type_carousel',
      $fields['background'],
      'pt-' . $fields['padding']['top'],
      'pb-' . $fields['padding']['bottom']
    ];

    $fields['slides'] = get_posts([
      'post_type' => $fields['post_type'],
      'post_status' => 'publish',
      'orderby' => $fields['orderby'],
      'order' => $fields['order'],
      'posts_per_page' => absint( $fields['posts_to_show'] )
    ]);

    if( \App\layout_has_bg( $fields['background'] ) ) {
      $classes[] = 'has-bg';
    }
   ?>

  <?php if( ! empty( $fields['slides'] ) ): ?>
    <section id="<?php echo e($fields['layout_id']); ?>" class="<?php echo e(implode( ' ', $classes )); ?>">
      <div class="container">
        <div class="post-type-carousel-wrap eh-container <?php echo e($fields['slider_settings']['dots'] === 'enabled' ? 'has-dots' : ''); ?> <?php echo e($fields['slider_settings']['arrows'] === 'enabled' ? 'has-arrows' : ''); ?>">
          <div class="post-type-carousel row"
               data-arrows="<?php echo e($fields['slider_settings']['arrows']); ?>"
               data-dots="<?php echo e($fields['slider_settings']['dots']); ?>"
               data-autoplay="<?php echo e($fields['slider_settings']['autoplay']); ?>"
               data-interval="<?php echo e($fields['slider_settings']['interval'] * 1000); ?>">

            <?php $__currentLoopData = $fields['slides']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php if( ! empty( $thumbnail = get_field( 'thumbnail', $slide->ID ) ) ): ?>
                <?php ($terms = get_the_terms( $slide->ID, 'category')); ?>

              <div class="ptc-slide col">
                <div class="ptc-slide-inner">
                  <div class="ptc-slide-content eh-child">
                    <div class="ptc-button">
                      <a class="btn btn-primary" href="<?php echo e(get_the_permalink( $slide->ID )); ?>" title="<?php echo e(__( 'Read more', 'hux' )); ?>">
                        <?php echo e(__( 'Read more', 'hux' )); ?>

                      </a>
                    </div>

                    <h4 class="ptc-slide-title">
                      <?php echo e(\App\title( $slide->ID )); ?>

                    </h4>

                    <?php if( ! empty( $category = $terms[0] ) ): ?>
                      <span class="ptc-category"><?php echo e($category->name); ?></span>
                    <?php endif; ?>

                    <?php if( ! empty( $icon = get_field('icon', $terms[0] ) ) ): ?>
                      <span class="ptc-icon"><?php echo $icon; ?></span>
                    <?php endif; ?>
                  </div>
                  <a class="ptc-slide-thumbnail mt-0 bg-cover eh-child" href="<?php echo e(get_the_permalink( $slide->ID )); ?>" title="<?php echo e(__( 'Read more', 'hux' )); ?>" style="background-image: url(<?php echo e($thumbnail['sizes']['hux-thumbnail']); ?>)"></a>
                </div>
              </div>
              <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>

          <div class="ptc-arrows"></div>
        </div>

        <?php if( ! empty( $fields['buttons'] ) ): ?>
          <div class="ptc-buttons btn-troop">
            <?php $__currentLoopData = $fields['buttons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php echo \App\the_wpc_button([
                'data' => $button['button']
              ]); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        <?php endif; ?>
      </div>
    </section>
  <?php endif; ?>

  <?php endwhile; ?>
<?php endif; ?>
