<?php 
  $thumbnail = get_field( 'thumbnail', get_the_ID() );
  $terms = get_the_terms( get_the_ID(), 'category');
 ?>

<article <?php (post_class("ptc-slide")); ?>>
  <div class="ptc-slide-inner">
    <div class="ptc-slide-content eh-child">
      <div class="ptc-button">
        <a class="btn btn-primary" href="<?php echo e(get_the_permalink()); ?>" title="<?php echo e(__( 'Read more', 'hux' )); ?>">
          <?php echo e(__( 'Read more', 'hux' )); ?>

        </a>
      </div>

      <h4 class="ptc-slide-title">
        <?php echo e(get_the_title()); ?>

      </h4>

      <?php if( ! empty( $category = $terms[0] ) ): ?>
        <span class="ptc-category"><?php echo e($category->name); ?></span>
      <?php endif; ?>

      <?php if( ! empty( $icon = get_field('icon', $terms[0] ) ) ): ?>
        <span class="ptc-icon"><?php echo $icon; ?></span>
      <?php endif; ?>
    </div>
    <a class="ptc-slide-thumbnail mt-0 bg-cover eh-child" href="<?php echo e(get_the_permalink()); ?>"
       title="<?php echo e(__( 'Read more', 'hux' )); ?>"
       style="background-image: url(<?php echo e($thumbnail['sizes']['hux-thumbnail']); ?>)"></a>
  </div>
</article>
