<?php if( have_rows('split_content') ): ?>
  <?php while( have_rows('split_content') ): ?> <?php  the_row()  ?>

  <?php 
    $fields = [
      'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( 'split_content' . '-' ),
      'uid' => uniqid( 'split_content' . '-' ),
      'title' => get_sub_field( 'title' ),
      'text' => get_sub_field( 'text' ),
      'image' => get_sub_field( 'image' ),
      'slider_type' => get_sub_field( 'slider_type' ),
      'slider_settings' => get_sub_field( 'split_content_slider_settings' ),
      'order' => get_sub_field( 'order' ),
      'slides' => get_sub_field( 'slides' ),
      'buttons' => get_sub_field( 'buttons' ),
    ];

    $classes = [
      'layout-item',
      'split_content',
      $fields['slider_type'],
    ];

  $datas = [];

  if($fields['slider_type'] !== 'no-slider') {
  $datas = [
      'data-uid='.$fields['uid'],
      'data-autoplay='.$fields['slider_settings']['autoplay'],
      'data-interval='.$fields['slider_settings']['interval'],
  ];
  }

   ?>

  <section id="<?php echo e($fields['layout_id']); ?>" class="<?php echo e(implode( ' ', $classes )); ?>" <?php echo e(implode( ' ', $datas )); ?>>

    <div class="row ml-0 mr-0 <?php echo e($fields['order']); ?>">
      <div class="col-md-6 pl-0 pr-0 pos-rel">
        <?php if( ! empty( $fields['image'] ) && ( $fields['slider_type'] !== 'image-slider' && $fields['slider_type'] !== 'both-slider' )): ?>
          <figure class="sc-thumbnail img-cover mb-0">
            <?php echo \App\get_responsive_attachment( $fields['image'], 'hux-thumbnail' ); ?>

          </figure>
        <?php else: ?>
          <div class="sc-image-slider <?php echo e($fields['uid']); ?>">
            <?php $__currentLoopData = $fields['slides']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="sc-image-slider-slide">
                <figure class="sc-thumbnail img-cover mb-0">
                  <?php echo \App\get_responsive_attachment( $slide['image'], 'hux-thumbnail' ); ?>

                </figure>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        <?php endif; ?>
        <?php if($fields['slider_type'] !== 'no-slider' ): ?>
          <div class="sc-slider-arrows <?php echo e($fields['uid']); ?>"></div>
        <?php endif; ?>
      </div>

      <div class="col-md-6 pl-0 pr-0 d-flex justify-content-center align-items-center">
        <div class="sc-wrap">
          <?php if($fields['slider_type'] !== 'both-slider' && $fields['slider_type'] !== 'text-slider'): ?>
            <div class="sc-item">
              <?php if( ! empty( $fields['title'] ) ): ?>
                <h3 class="sc-title"><?php echo e($fields['title']); ?></h3>
              <?php endif; ?>

              <?php if( ! empty( $text = get_sub_field( 'text' ) ) ): ?>
                <div class="sc-text"><?php echo $text; ?></div>
              <?php endif; ?>
            </div>
          <?php else: ?>
            <div class="sc-text-slider <?php echo e($fields['uid']); ?>">
              <?php $__currentLoopData = $fields['slides']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="sc-item sc-text-slider-slide">
                  <?php if( ! empty( $slide['title'] ) ): ?>
                    <h3 class="sc-title"><?php echo e($slide['title']); ?></h3>
                  <?php endif; ?>

                  <?php if( ! empty( $text = $slide['text'] ) ): ?>
                    <div class="sc-text"><?php echo $text; ?></div>
                  <?php endif; ?>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          <?php endif; ?>
          <?php if( ! empty( $fields['buttons'] ) ): ?>
            <div class="sc-buttons mt-4">
              <?php $__currentLoopData = $fields['buttons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo \App\the_wpc_button([
                  'data' => $button['button']
                ]); ?>

              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </section>

  <?php endwhile; ?>
<?php endif; ?>
