<?php 
  $fields = [
    'layout_id' => get_sub_field( 'layout_id' ) ? get_sub_field( 'layout_id' ) : uniqid( get_row_layout() . '-' ),
    'why_us' =>  get_sub_field('why_us'),
    'padding' => get_sub_field( 'why_us_padding' ),
  ];

  $classes = [
    'layout-item',
    'why_us',
    'pt-' . $fields['padding']['top'],
    'pb-' . $fields['padding']['bottom']
  ];
 ?>

<section id="<?php echo e($fields['layout_id']); ?>" class="<?php echo e(implode( ' ', $classes )); ?>">
  <div class="container">
    <div class="row why_us_block">
      <?php if( ! empty( $fields['why_us'] ) ): ?>
        <?php $__currentLoopData = $fields['why_us']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-sm-3">
            <?php if( ! empty( $icon = $wu['icon'] ) ): ?>
              <span class="wu-icon"><?php echo $icon; ?></span>
            <?php endif; ?>
            <?php if( ! empty( $wu['subtitle'] ) ): ?>
              <span class="wu-subtitle"><?php echo e($wu['subtitle']); ?></span>
            <?php endif; ?>
            <?php if( ! empty( $wu['title'] ) && !$wu['is_price']): ?>
              <h4 class="wu-title"><?php echo $wu['title']; ?></h4>
            <?php endif; ?>
              <?php if( ! empty($price = $wu['price'] ) && $wu['is_price']): ?>
                <span class="wu-title"><?php echo \App\generate_price($price); ?></span>
              <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php endif; ?>
    </div>
  </div>
</section>
